
import numpy as np, random

def _pf_eigvec_column_stochastic(K, iters=256, eps=1e-12):
    n = K.shape[0]
    v = np.ones(n)/n
    for _ in range(iters):
        v_new = K @ v
        s = v_new.sum()
        if s>0: v_new = v_new/s
        if np.linalg.norm(v_new - v, 1) < eps:
            break
        v = v_new
    return v / max(1e-12, v.sum())

def tie_break_pf_born(adjacency):
    A = np.array(adjacency, dtype=float)
    eta = 1e-6
    A = A + eta*np.eye(A.shape[0])
    colsum = A.sum(axis=0, keepdims=True)
    colsum[colsum==0] = 1.0
    K = A / colsum
    v = _pf_eigvec_column_stochastic(K)
    w = v**2
    w = w / max(1e-12, w.sum())
    r = random.random()
    cdf = 0.0
    for i, wi in enumerate(w):
        cdf += wi
        if r <= cdf:
            return i, w
    return len(w)-1, w
